using System;
using System.IO;
using System.Diagnostics;
using System.Runtime.Serialization;

using Team_Project.PersistencyManagers.Storages;

namespace Team_Project.Elements
{
	public class LockElement: IProjectElement
	{
		public static readonly string Suff = ".lock";
		protected string name;
		protected string fullPath;
		protected string path;
		protected string lockerID;
		protected string requestID;
		protected DateTime lockTime = DateTime.MinValue;

		public LockElement(SerializationInfo info)
		{
			project = info.GetString("project");
			//Trace.WriteLine("Deserialized project = " + project);
			path = info.GetString("path");
			//Trace.WriteLine("Deserialized path = " + path);
			name = info.GetString("name");
			//Trace.WriteLine("Deserialized name = " + name);
			this.fullPath = path + "\\" + name;
			lockerID = info.GetString("locker");
			//Trace.WriteLine("Deserialized lockerID = " + lockerID);
			lockTime = info.GetDateTime("LockTime");
			//Trace.WriteLine("Deserialized lockTime = " + lockTime.ToString());
			requestID = info.GetString("requestID");
			//Trace.WriteLine("Deserialized requestID = " + requestID);
		}

		public LockElement(string proj,string path,string name)
		{
			Trace.WriteLine("LockElement instance created");
			this.path = path;
			this.name = name;
			this.fullPath = path + "\\" + name;
			project = proj;
			requestID = Globals.Instance.LocalCopyName + " "+((LockCounter)Globals.Instance.Data["LockCounter"]).Next;
		}

		public string LockerID
		{
			get{return lockerID;}
			set{lockerID = value;}
		}

		public string RequestID
		{
			get{return requestID;}
			set{requestID = value;}
		}

		public string RequesterCopyName
		{
			get
			{
				int f = requestID.LastIndexOf(' ');
				return requestID.Substring(0,f);
			}
		}

		public DateTime LockTime
		{
			set{lockTime = value;}
			get
			{
				if(lockTime == DateTime.MinValue)
					return DateTime.Now;
				else
					return lockTime;
			}
		}



		public void Serialize(SerializationInfo info)
		{
			info.AddValue("project",project);
			info.AddValue("path",path);
			info.AddValue("name",name);
			info.AddValue("locker",lockerID);
			info.AddValue("LockTime",LockTime);
			info.AddValue("requestID",requestID);
		}

		#region IProjectElement Members

		public override string Suffix
		{
			get{return Suff;}
		}

		public override string FullName
		{
			get{return fullPath;}
		}

		public override string Name
		{
			get{return name;}
		}

		public override string Location
		{
			get{return path;}
			set{path = value;}
		}

		public override Stream DataInput
		{
			set
			{
				StreamReader sr = new StreamReader(value);
				lockerID = sr.ReadLine();
				requestID = sr.ReadLine();
				string date = sr.ReadLine();
				string[] dd = date.Split('|');
				LockTime = new DateTime(int.Parse(dd[0]),int.Parse(dd[1]),int.Parse(dd[2]),
					int.Parse(dd[3]),int.Parse(dd[4]),int.Parse(dd[5]),0);
			}
		}

		public override void DestroyFrom(Team_Project.PersistencyManagers.Storages.IStorage src)
		{
			src.Delete(Location,Name+Suff);
		}

		public override void WriteTo(Team_Project.PersistencyManagers.Storages.IStorage dest)
		{
			using(Stream destStr = dest.OpenWrite(Location,Name+Suff))
			{
				WriteTo(destStr);
			}
		}

		public override void WriteTo(Stream destStr)
		{
			StreamWriter sw = new StreamWriter(destStr);
			sw.WriteLine(lockerID);
			sw.WriteLine(requestID);
			sw.WriteLine(LockTime.ToString("yyyy|MM|dd|hh|mm|ss"));
			sw.Flush();
		}

		public override void LoadFrom(Team_Project.PersistencyManagers.Storages.IStorage src)
		{
			using (Stream dat = src.OpenRead(Location,Name+Suff))
			{
				DataInput = dat;
			}
		}
		#endregion

		#region IDisposable Members

		public override void Dispose()
		{
		}

		#endregion

		public override string ToString()
		{
			return "LE -> proj=" + project + " name="+FullName+" locker="+
				lockerID + " LockTime=" + LockTime + " requestID=" + RequestID;
		}

	}
}
